-- name: extra.lua
-- description: Contains functions and variables that aren't too essential for the mod. Can't use mod_file_exists() to suppress error messages if the file is missing for coopEX as long as I'm still interested in making the mod compatible with it.

gGlobalSyncTable.ipopups = true --Global pop-ups enabled by default.

pauseMenuShowLevelID = false
extraCam = false

local local_popup_state = true --Local pop-ups enabled by default.

function local_popup(msg) if local_popup_state then djui_popup_create(msg, 2) end end --mostly for warp error popups and debug hud state

function popup_config(userInput)
    if userInput ~= nil then
        if string.upper(userInput) == "ON" then
            if network_is_server() then
                gGlobalSyncTable.ipopups = true
                pseudo_error_handler("ENABLED", "Restart")
            else pseudo_error_handler("HOST", "this command.") end
        elseif string.upper(userInput) == "OFF" then
            if network_is_server() then
                gGlobalSyncTable.ipopups = false
                pseudo_error_handler("DISABLED", "Restart")
            else pseudo_error_handler("HOST", "this command.") end
        elseif string.upper(userInput) == "LOCAL" then--Can't combine this condition with "or args[2] == nil" into a single line because string.upper() doesn't like nil.
            local_popup_state = not local_popup_state
            if local_popup_state then pseudo_error_handler("ENABLED", "Local")
            else pseudo_error_handler("DISABLED", "Local") end
        else pseudo_error_handler("SYNTAX", "\\#ffff00\\/warp popups \\#00ff00\\on\\#ffffff\\|\\#ff0000\\off\\#ffffff\\|\\#ffff00\\local") end
    else
        local_popup_state = not local_popup_state
        if local_popup_state then pseudo_error_handler("ENABLED", "Local")
        else pseudo_error_handler("DISABLED", "Local") end
    end
end

function pseudo_global_popup(verb, level_check, area_check, act_check, message_name, name_colour)
    if gGlobalSyncTable.ipopups then --Pretend that these pop-ups are "global" for people in the same area.
        if (act_check == 0) or (course_is_main_course(gNetworkPlayers[0].currCourseNum) == false) then
            if get_level_name(gNetworkPlayers[0].currCourseNum, level_check, area_check) ~= nil then
                djui_popup_create(name_colour..message_name .. "\\#ffffff\\ " .. tostring(verb) .. ": \\#10ff10\\" .. get_level_name(gNetworkPlayers[0].currCourseNum, level_check, area_check), 2)
            end
        else
            if get_level_name(gNetworkPlayers[0].currCourseNum, level_check, area_check) ~= nil then
                if get_star_name(gNetworkPlayers[0].currCourseNum, act_check) ~= nil then
                    djui_popup_create(name_colour..message_name
                    .. "\\#ffffff\\ " .. tostring(verb) .. ": \\#10ff10\\" .. get_level_name(gNetworkPlayers[0].currCourseNum, level_check, area_check)
                    .. "\\#ffffff\\, \\#ffff00\\" .. get_star_name(gNetworkPlayers[0].currCourseNum, act_check), 2)
                end
            end
        end
    end
end

local function mario_update(m)
    if extraCam and get_cutscene_from_mario_status(m.area.camera) ~= CUTSCENE_DANCE_CLOSEUP then --Show the hud again if the player moved to a different area while the closeup camera was enabled. Not in on_warp() because the event hook doesn't account for cutscenes like the ending Peach cutscene.
        if m.marioObj.header.gfx.node.flags == 37 then m.marioObj.header.gfx.node.flags = 33 end --Just to be safe.
        hud_show()
        extraCam = false
    end
    if gGlobalSyncTable.BowserFix then
        --[[ Bandaid fix for a behavior bug where oAction stays at 5 if the level initializes and the cutscene finishes with multiple players close to Bowser.
        There's still a strange bug where Bowser would keep on alternating between oAction 5 and 6 during the cutscene beyond the intended frequency if there are multiple players near Bowser during the cutscene. Attempting to force it to stay at 5 won't work. Might partially be a desync issue, an aggro bug based on distance or confusion with choosing an action. ]]
        if afterCutscene and get_cutscene_from_mario_status(gMarioStates[0].area.camera) ~= CUTSCENE_ENTER_BOWSER_ARENA and count_objects_with_behavior(get_behavior_from_id(id_bhvBowser)) ~= 0 then
            if find_object_with_behavior(get_behavior_from_id(id_bhvBowser)).oAction == 5 or find_object_with_behavior(get_behavior_from_id(id_bhvBowser)).oAction == 6 then
                if find_object_with_behavior(get_behavior_from_id(id_bhvBowser)).oBehParams2ndByte == 1 then
                    find_object_with_behavior(get_behavior_from_id(id_bhvBowser)).oAction = 13 --High jump.
                else find_object_with_behavior(get_behavior_from_id(id_bhvBowser)).oAction = 0 end
                afterCutscene = false
            elseif find_object_with_behavior(get_behavior_from_id(id_bhvBowser)).oAction == 0 or find_object_with_behavior(get_behavior_from_id(id_bhvBowser)).oAction == 13 then afterCutscene = false end --I seemingly misunderstood what "tangible" means in the context of the game. I CAN'T try avoiding a desync bug if a player dies during the cutscene by making them intangible with cur_obj_become_intangible() during the cutscene.
        end
    end
    if hide_attempt then --Attempt to make the level reset more smooth and obvious.
        play_sound(SOUND_MENU_MARIO_CASTLE_WARP2, gMarioStates[0].marioObj.header.gfx.cameraToObject)
        gMarioStates[0].particleFlags = PARTICLE_MIST_CIRCLE --The particle does not render with the warp hook but I might move this if-statement block back to on_warp() and delete this line if the mod performs worse.
        play_transition(WARP_TRANSITION_FADE_FROM_STAR, 14, 255, 255, 255)
        hide_attempt = false
    end
end

--[[ Taken from Farris's "Streaming Music Mod" to help test and debug this mod with the hud_render() function.
Left in to help those who are not familiar with ids. ]]
local function hud_render()
    if (pauseMenuShowLevelID == true and is_game_paused()) then
        djui_hud_set_resolution(RESOLUTION_DJUI);
        djui_hud_set_font(FONT_NORMAL);
        local screenWidth = djui_hud_get_screen_width()
		local screenHeight = djui_hud_get_screen_height()
        local height = 64
        local y = screenHeight - height
		local text = "COURSE#: " .. gNetworkPlayers[0].currCourseNum .. " LEVEL AREA SEQ: " .. gNetworkPlayers[0].currLevelAreaSeqId .. " LEVEL ID: " .. gNetworkPlayers[0].currLevelNum .. " AREA INDEX: ".. gNetworkPlayers[0].currAreaIndex .. " ACT #: " .. gNetworkPlayers[0].currActNum
		djui_hud_print_text(text, 5, y, 1);
    end
end

function warp_extra(extraType, extraSetting)
    if extraType ~= nil then
        if string.upper(extraType) == "PEACH" then --Trigger the Peach ending cutscene without needing to grab a Grand Star. Will prevent you from pausing until you change screens if the romhack doesn't have the cutscene.
            if extraSetting ~= nil then
                if string.upper(extraSetting) == "ALL" then
                    if network_is_server() then
                        network_send(false, { extra = "peach" })
                        level_trigger_warp(gMarioStates[0], 23)
                    else pseudo_error_handler("HOST", "\\#ffff00\\/warp extra peach \\#10ff10\\all") end
                else pseudo_error_handler("UNSUPPORTED", " option") end
            else level_trigger_warp(gMarioStates[0], 23) end
        elseif string.upper(extraType) == "CAKE" then --After credits cake end.
            if extraSetting ~= nil then
                if string.upper(extraSetting) == "ALL" then
                    if network_is_server() then
                        network_send(false, { extra = "cake" })
                        level_trigger_warp(gMarioStates[0], WARP_OP_CREDITS_END)
                    else pseudo_error_handler("HOST", "\\#ffff00\\/warp extra cake \\#10ff10\\all") end
                else pseudo_error_handler("UNSUPPORTED", " option") end
            else level_trigger_warp(gMarioStates[0], WARP_OP_CREDITS_END) end
        elseif string.upper(extraType) == "CAM" then --Will definitely cause crashes if you forcefully try to override a planned in-game cutscene. Keep the format as is or just remove this command option to be safe.
            if get_cutscene_from_mario_status(gMarioStates[0].area.camera) == CUTSCENE_DANCE_DEFAULT or get_cutscene_from_mario_status(gMarioStates[0].area.camera) == CUTSCENE_STOP or get_cutscene_from_mario_status(gMarioStates[0].area.camera) == 0 or get_cutscene_from_mario_status(gMarioStates[0].area.camera) == nil then
                if pcall(start_cutscene, gMarioStates[0].area.camera, CUTSCENE_DANCE_CLOSEUP) then
                    extraCam = true
                    gMarioStates[0].marioObj.header.gfx.node.flags = 37 --Billboard render flag.
                    hud_hide()
                    start_cutscene(gMarioStates[0].area.camera, CUTSCENE_DANCE_CLOSEUP)
                else log_to_console("\"/warp extra cam\" broke something") end
            elseif get_cutscene_from_mario_status(gMarioStates[0].area.camera) == CUTSCENE_DANCE_CLOSEUP then
                if pcall(start_cutscene, gMarioStates[0].area.camera, CUTSCENE_DANCE_DEFAULT) then
                    extraCam = false
                    gMarioStates[0].marioObj.header.gfx.node.flags = 33
                    hud_show()
                    soft_reset_camera(gMarioStates[0].area.camera) --CUTSCENE_DANCE_DEFAULT, CUTSCENE_STOP, 0 or nil should also work
                else
                    log_to_console("\"/warp extra cam\" broke something")
                    extraCam = false
                    gMarioStates[0].marioObj.header.gfx.node.flags = 33
                    hud_show()
                    reset_camera(gMarioStates[0].area.camera)
                end
            end
        elseif string.upper(extraType) == "BOWSER" then --Experimental. Expect Bowser to still break in certain ways.
            if network_is_server() then
                if extraSetting ~= nil then
                    if string.upper(extraSetting) == "ALL" then --Someone dying during the cutscene will cause a desync. Enabled by default.
                        gGlobalSyncTable.allBowser = not gGlobalSyncTable.allBowser
                        pseudo_error_handler("BCUTSCENE", " available to all: \\#ffff00\\" .. tostring(gGlobalSyncTable.allBowser))
                    elseif string.upper(extraSetting) == "ON" then --Enabled by default.
                        gGlobalSyncTable.BowserFix = true
                        pseudo_error_handler("BCOMPAT", " have been \\#10ff10\\enabled\\#ffffff\\.")
                    elseif string.upper(extraSetting) == "OFF" then --Use this if romhacks override Bowser's behavior or give him custom behaviors.
                        gGlobalSyncTable.BowserFix = false
                        pseudo_error_handler("BCOMPAT", " have been \\#ff0000\\disabled\\#ffffff\\.")
                    elseif string.upper(extraSetting) == "CUT" then --Toggle option to show the Bowser intro cutscenes. Theoretically is the option with the lowest chance to break when disabled. Last resort. Enabled by default.
                        gGlobalSyncTable.BowserCut = not gGlobalSyncTable.BowserCut
                        pseudo_error_handler("BCUTSCENE", ": \\#ffff00\\" .. tostring(gGlobalSyncTable.BowserCut))
                    else pseudo_error_handler("UNSUPPORTED", " option") end
                else
                    gGlobalSyncTable.BowserFix = not gGlobalSyncTable.BowserFix
                    pseudo_error_handler("BCOMPAT", ": \\#ffff00\\" .. tostring(gGlobalSyncTable.BowserFix))
                end
            else pseudo_error_handler("HOST", "\\#ffff00\\/warp extra bowser") end
        else pseudo_error_handler("UNSUPPORTED", "") end
    else pseudo_error_handler("UNSUPPORTED", "") end
end

hook_event(HOOK_MARIO_UPDATE, mario_update)
hook_event(HOOK_ON_HUD_RENDER, hud_render)